#version 330 core

in vec3 position;
in vec3 normal;
in vec2 uv;

out vec3 worldNormal;
out vec2 fragmentUV;

uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

void main() 
{
	fragmentUV = uv;
	worldNormal = (modelMatrix * vec4(normal, 0.0)).xyz;
	gl_Position = projectionMatrix * viewMatrix * modelMatrix * vec4(position, 1);
}