#version 330 core

in vec3 worldNormal;
in vec2 fragmentUV;

uniform vec3 Color;
uniform float AmbientIntensity;
uniform float DiffuseIntensity;
uniform vec3 Direction;
  
uniform sampler2D colorTexture;

out vec4 fragColor;

void main()
{
	vec4 AmbientColor = vec4(Color, 1.0f) * AmbientIntensity;
	
	float DiffuseFactor = dot(normalize(worldNormal), normalize(-Direction));
	
	vec4 DiffuseColor;
	
	if (DiffuseFactor > 0) {
		DiffuseColor = vec4(Color, 1.0f) * DiffuseIntensity * DiffuseFactor;
    }
    else {
        DiffuseColor = vec4(0.0f, 0.0f, 0.0f, 1.0f);
    }

	vec3 textureColor = texture(colorTexture, fragmentUV).rgb; 
	fragColor = vec4(textureColor, 1.0) * (AmbientColor + DiffuseColor);
}