#version 330 core

in vec3 position;
in vec3 normal;
in vec2 uv;
in vec3 tangent;

out vec3 worldNormal;
out vec3 worldTangent;
out vec2 fragmentUV;
out vec4 shadowCoord;


uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;
uniform mat4 DepthBiasVP;
uniform vec3 Direction;

void main() 
{
	fragmentUV = uv;
	worldNormal = (modelMatrix * vec4(normal, 0.0)).xyz;
	worldTangent = (modelMatrix * vec4(tangent, 0.0)).xyz;
	shadowCoord = DepthBiasVP * modelMatrix * vec4(position, 1);

	gl_Position = projectionMatrix * viewMatrix * modelMatrix * vec4(position, 1);
}