#version 330 core

in vec3 worldNormal;
in vec2 fragmentUV;
in vec3 worldTangent;
in vec4 shadowCoord;

uniform vec3 Color;
uniform float AmbientIntensity;
uniform float DiffuseIntensity;
uniform vec3 Direction;
uniform float alpha;
  
uniform sampler2D colorTexture;
uniform sampler2D normalTexture;
uniform sampler2DShadow shadowMap;
uniform sampler2D glowMap;

out vec4 fragColor;

vec2 poissonDisk[16] = vec2[]( 
   vec2( -0.94201624, -0.39906216 ), 
   vec2( 0.94558609, -0.76890725 ), 
   vec2( -0.094184101, -0.92938870 ), 
   vec2( 0.34495938, 0.29387760 ), 
   vec2( -0.91588581, 0.45771432 ), 
   vec2( -0.81544232, -0.87912464 ), 
   vec2( -0.38277543, 0.27676845 ), 
   vec2( 0.97484398, 0.75648379 ), 
   vec2( 0.44323325, -0.97511554 ), 
   vec2( 0.53742981, -0.47373420 ), 
   vec2( -0.26496911, -0.41893023 ), 
   vec2( 0.79197514, 0.19090188 ), 
   vec2( -0.24188840, 0.99706507 ), 
   vec2( -0.81409955, 0.91437590 ), 
   vec2( 0.19984126, 0.78641367 ), 
   vec2( 0.14383161, -0.14100790 ) 
);

vec3 CalcBumpedNormal()
{
    vec3 Normal = normalize(worldNormal);
    vec3 Tangent = normalize(worldTangent);
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    vec3 Bitangent = cross(Tangent, Normal);
    vec3 BumpMapNormal = texture(normalTexture, fragmentUV).xyz;
    BumpMapNormal = 2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0);
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
} 

void main()
{
	vec3 Normal = CalcBumpedNormal();
	
	vec4 AmbientColor = vec4(Color, 1.0f) * AmbientIntensity;
	
	float DiffuseFactor = dot(normalize(Normal), normalize(-Direction));
	
	vec4 DiffuseColor;
	
	if (DiffuseFactor > 0) {
		DiffuseColor = vec4(Color, 1.0f) * DiffuseIntensity * DiffuseFactor;
    }
    else {
        DiffuseColor = vec4(0.0f, 0.0f, 0.0f, 1.0f);
    }

    //vec3 n = normalize( normalCameraspace );
    //vec3 l = normalize( lightDirectionCameraspace );

    //float cosTheta = clamp( dot( n, l ), 0, 1 );
    //float bias = 0.2*tan(acos(cosTheta)); 
    // cosTheta is dot( n,l ), clamped between 0 and 1
    //bias = clamp(bias, 0, 0.01);

    float bias = 0.0025;
    float visibility = 1.0;

    for (int i=0;i<6;i++) {
        // use either :
        //  - Always the same samples.
        //    Gives a fixed pattern in the shadow, but no noise
        int index = i;
        //  - A random sample, based on the pixel's screen location. 
        //    No banding, but the shadow moves with the camera, which looks weird.
        // int index = int(16.0*random(gl_FragCoord.xyy, i))%16;
        //  - A random sample, based on the pixel's position in world space.
        //    The position is rounded to the millimeter to avoid too much aliasing
        // int index = int(16.0*random(floor(Position_worldspace.xyz*1000.0), i))%16;
        
        // being fully in the shadow will eat up 4*0.2 = 0.8
        // 0.2 potentially remain, which is quite dark.
        visibility -= 0.2*(1.0-texture( shadowMap, vec3(shadowCoord.xy + poissonDisk[index]/700.0,  (shadowCoord.z-bias)/shadowCoord.w) ));
    }

    vec3 textureColor = texture(colorTexture, fragmentUV).rgb;
    fragColor = vec4((vec4(textureColor, 1.0f) * ( AmbientColor +  DiffuseColor * visibility)).rgb, alpha);
}