#version 330 core

uniform mat4 mvp;
uniform mat4 m, v, p; // just to be safe


// Note: we use the layout stuff instead of glBindAttribLocation
layout(location = 0) in vec3 in_position; // coorsinates of the vertex
layout(location = 1) in vec4 in_color; // color of the vertex
layout(location = 2) in vec3 in_v_normal; // vertex normal
layout(location = 3) in vec2 in_v_texcoord; // texture coordinates

out vec4 ex_color; // output color
out vec4 ex_normal; // output vertex_normal

void main(void) {
	// set vertex color
	ex_normal = vec4(in_v_normal, 1.0);
	ex_color = vec4(in_color);
	// set final vertex position
	gl_Position = mvp * vec4(in_position, 1.0);
}