#version 330 core

#extension EXT_geometry_shader4:enable

layout(points) in;
layout(triangle_strip , max_vertices=4) out;

in vec2 ex_halfwidthheight[1];

 void main() {
	
	for(int i = 0; i < gl_VerticesIn; i++) {
		float halfwidth = ex_halfwidthheight[i].x;
		float halfheight = ex_halfwidthheight[i].y;
		
		vec2 topleft = vec2(gl_in[i].gl_Position.x-halfwidth, gl_in[i].gl_Position.y-halfheight);
		vec2 bottomright = vec2(topleft.x+halfwidth+halfwidth, topleft.y+halfheight+halfheight); 
		vec4 p1 = vec4(topleft.x, topleft.y,gl_in[i].gl_Position.z,1);
		vec4 p2 = vec4(bottomright.x, topleft.y,gl_in[i].gl_Position.z,1);
		vec4 p3 = vec4(topleft.x, bottomright.y,gl_in[i].gl_Position.z,1);
		vec4 p4 = vec4(bottomright.x, bottomright.y,gl_in[i].gl_Position.z,1);
		
		
		gl_Position = p1;
		EmitVertex();
		gl_Position = p2;
		EmitVertex();
		gl_Position = p3;
		EmitVertex();
		gl_Position = p4;

		EmitVertex();
		EndPrimitive();
	}
  
}