#version 330 core

#extension EXT_geometry_shader4:enable

layout(points) in;
layout(triangle_strip , max_vertices=4) out;


uniform vec2 widthheight;
out vec2 ex_geom_tex_coord; // output texture coordinate

uniform vec4 texcoord1;
uniform vec4 texcoord2;
uniform vec4 texcoord3;

 void main() {
	

	
	for(int i = 0; i < gl_VerticesIn; i++) {
		vec4 pos = gl_in[i].gl_Position;
		vec4 texcoord;
		if (pos.z == 0) {
			texcoord = texcoord1;
		} else if(pos.z == 0) {
			texcoord = texcoord2;
		} else {
			texcoord = texcoord3;
		}
		
		vec2 topleft = vec2(pos.x-(widthheight.x*0.5f),pos.y-(widthheight.y*0.5f));
		vec2 bottomright = vec2(topleft.x+widthheight.x, topleft.y+widthheight.y); 
		vec4 p1 = vec4(topleft.x, topleft.y,0,1);
		vec4 p2 = vec4(bottomright.x, topleft.y,0,1);
		vec4 p3 = vec4(topleft.x, bottomright.y,0,1);
		vec4 p4 = vec4(bottomright.x, bottomright.y,0,1);
		vec2 t1 = vec2(texcoord.x,texcoord.y);
		vec2 t2 = vec2(texcoord.x+texcoord.z,texcoord.y);
		vec2 t3 = vec2(texcoord.x,texcoord.y+texcoord.w);
		vec2 t4 = vec2(texcoord.x+texcoord.z,texcoord.y+texcoord.w);
		
		
		gl_Position = p1;
		ex_geom_tex_coord = t1;
		EmitVertex();
		gl_Position = p2;
		ex_geom_tex_coord = t2;
		EmitVertex();
		gl_Position = p3;
		ex_geom_tex_coord = t3;
		EmitVertex();
		gl_Position = p4;
		ex_geom_tex_coord = t4;
		EmitVertex();
		EndPrimitive();
	}
  
}