#version 330 core

uniform mat4 mvp;
uniform mat4 model_matrix; 
uniform mat4 normal_matrix;

// Note: we use the layout stuff instead of glBindAttribLocation
layout(location = 0) in vec3 in_position; // coorsinates of the vertex
layout(location = 1) in vec4 in_color; // color of the vertex
layout(location = 2) in vec3 in_v_normal; // vertex normal
layout(location = 3) in vec2 in_v_texcoord; // texture coordinates

out vec4 ex_position; 
out vec4 ex_color; // output color
out vec3 ex_normal; // output vertex_normal

void main(void) {
	// set vertex color
	vec3 temp_normal=normalize(mat3(normal_matrix)*in_v_normal);
	ex_normal = temp_normal;
	ex_color = vec4(in_color);
	// set final vertex position
	gl_Position = mvp * vec4(in_position, 1.0);
	ex_position = (model_matrix * vec4(in_position, 1.0));
}