#version 330 core

uniform vec3 light_vector;
uniform vec3 ambient_light_color;
uniform vec3 diffuse_light_color;

uniform vec3 cam_position;

uniform float ambient_intenisty;
uniform float diffuse_intenisty;
uniform float specular_intenisty;
uniform float specular_exponent;

in vec4 ex_position;

in vec4 ex_color;

in vec3 ex_normal;

out vec4 out_color;

void main(void)
{

	float diff=0;
	float spec=0;

	vec3 view_vector=cam_position - ex_position.xyz;

	vec3 temp_normal = ex_normal.xyz;
	temp_normal = normalize(temp_normal);

	vec3 kA=ex_color.xyz * ambient_intenisty;
	vec3 kD=ex_color.xyz * diffuse_intenisty;
	vec3 kS=ex_color.xyz * specular_intenisty;

	diff = dot(light_vector,temp_normal);
	if(diff<0){
		diff=0;
	}

	vec3 halfway=light_vector - view_vector;
	halfway=normalize(halfway);
	float dotHN=dot(halfway,temp_normal);
	if(dotHN<0){
		spec=0;
	}else{

		spec=pow(dotHN,specular_exponent);
	}

	vec3 temp_color=(ambient_light_color * kA +diff * diffuse_light_color * (kD  + kS * spec)).xyz;
		
	out_color.rgb = clamp(temp_color.xyz, 0.0, 1.0);
	out_color.a = 0.0;
}