#version 330 core

#extension EXT_geometry_shader4:enable
#extension GL_ARB_gpu_shader5 : require 

uniform mat4 mvp;
uniform vec3 x;
uniform vec3 y;
uniform vec3 z;
uniform vec3 pxy;
uniform vec3 nxy;
uniform float width;
uniform float texture_x_offset;
uniform int[8] renderorder;

layout(points, invocations=8) in;
layout(triangle_strip, max_vertices=4) out;


in vec4 ex_color[]; // output color

out vec4 ex_geom_color; // output color
out vec2 ex_geom_tex_coord;

 void main()
{
	int rendertarget = renderorder[gl_InvocationID];
	for(int i = 0; i < gl_VerticesIn; i++) {
	vec4 color = ex_color[i];
	vec4 local_x;
	vec4 local_z = vec4(z, 1.0f);
	float ytex_low;
	float ytex_high;
	if (rendertarget == 0) {
		local_x = vec4(x, 1.0f);
		ytex_low = 0.5;
		ytex_high = 1;
		color = vec4(1.0,0.0,0.0,1.0);
	} else if (rendertarget == 1) {
		local_x = vec4(pxy, 1.0f);
		ytex_low = 0.5;
		ytex_high = 1;
		color = vec4(0.7,0.0,0.0,1.0);
	} else if (rendertarget == 2) {
		local_x = vec4(y, 1.0f);
		ytex_low = 0.5;
		ytex_high = 1;
		color = vec4(0.4,0.0,0.0,1.0);
	} else if (rendertarget == 3) {
		local_x = vec4(nxy, 1.0f);
		ytex_low = 0.5;
		ytex_high = 1;
		color = vec4(0.1,0.0,0.0,1.0);
	} else if (rendertarget == 4) {
		local_x = vec4(-x, 1.0f);
		ytex_low = 0.5;
		ytex_high = 0;
		color = vec4(0.0,1.0,0.0,1.0);
	} else if (rendertarget == 5) {
		local_x = vec4(-pxy, 1.0f);
		ytex_low = 0.5;
		ytex_high = 0;
		color = vec4(0.0,0.7,0.0,1.0);
	} else if (rendertarget == 6) {
		local_x = vec4(-y, 1.0f);
		ytex_low = 0.5;
		ytex_high = 0;
		color = vec4(0.0,0.4,0.0,1.0);
	} else if (rendertarget == 7) {
		local_x = vec4(-nxy, 1.0f);
		ytex_low = 0.5;
		ytex_high = 0;
		color = vec4(0.0,0.1,0.0,1.0);
	}
	float x_tex = (width*16);
	
	float offset = -texture_x_offset;
	
	// v1 
	ex_geom_tex_coord = vec2(offset,ytex_low);
	ex_geom_color = color;
	gl_Position = (gl_in[i].gl_Position);
	gl_Position.x = gl_Position.x;
	gl_Position.y = gl_Position.y;
	gl_Position.z = gl_Position.z;
	gl_Position = mvp*gl_Position;
	EmitVertex();
	
	// v2
	ex_geom_tex_coord = vec2(offset,ytex_high);
	ex_geom_color = color;
	gl_Position = (gl_in[i].gl_Position);
	gl_Position.x = gl_Position.x + local_x.x;
	gl_Position.y = gl_Position.y + local_x.y;
	gl_Position.z = gl_Position.z + local_x.z;
	gl_Position = mvp*gl_Position;
	EmitVertex();
	
	
	
	// v4
	ex_geom_tex_coord = vec2(x_tex+offset,ytex_low);
	ex_geom_color = color;
	gl_Position = (gl_in[i].gl_Position);
	gl_Position.x = gl_Position.x + local_z.x;
	gl_Position.x = gl_Position.x;
	
	gl_Position.y = gl_Position.y + local_z.y;
	gl_Position.y = gl_Position.y;
	
	gl_Position.z = gl_Position.z + local_z.z;
	gl_Position.z = gl_Position.z;
	gl_Position = mvp*gl_Position;
	EmitVertex();
	
	// v3
	ex_geom_tex_coord = vec2(x_tex+offset,ytex_high);
	ex_geom_color = color;
	gl_Position = (gl_in[i].gl_Position);
	gl_Position.x = gl_Position.x + local_x.x;
	gl_Position.x = gl_Position.x + local_z.x;
	
	gl_Position.y = gl_Position.y + local_x.y;
	gl_Position.y = gl_Position.y + local_z.y;
	
	gl_Position.z = gl_Position.z + local_x.z;
	gl_Position.z = gl_Position.z + local_z.z;
	
	gl_Position = mvp*gl_Position;
	EmitVertex();
	EndPrimitive();
	}
	
}