#version 330 core
#extension GL_EXT_geometry_shader4 : enable

//texcoord width/height of a Char in the textere
uniform float tex_width;
uniform float tex_height;

layout(location = 1) in vec2 in_char_indices; // coordinates of the vertex

layout(points) in;
layout(triangle_strip, max_vertices=4) out;

out vec2 ex_geom_pos;
out vec2 ex_geom_tex_coord;


 void main()
{
	
	{
		ex_geom_pos = vec2(gl_position.x+0,gl_position.y+0);
		ex_geom_tex_coord = vec2(in_char_indices.x * tex_width , in_char_indices.y * tex_height);
		EmitVertex();
	}
	{
		ex_geom_pos = vec2(gl_position.x+1,gl_position.y+0);
		ex_geom_tex_coord = vec2(in_char_indices.x * tex_width + tex_width , in_char_indices.y * tex_height);
		EmitVertex();
	}
	{
		ex_geom_pos = vec2(gl_position.x+0,gl_position.y+1);
		ex_geom_tex_coord = vec2(in_char_indices.x * tex_width , in_char_indices.y * tex_height + tex_height);
		EmitVertex();
	}
	{
		ex_geom_pos = vec2(gl_position.x+1,gl_position.y+1);
		ex_geom_tex_coord = vec2(in_char_indices.x * tex_width + width , in_char_indices.y * tex_height + tex_height);
		EmitVertex();
	}
  EndPrimitive();
}