#version 330 core

uniform mat4 mvp;
uniform mat4 model_matrix; 
uniform mat4 normal_matrix;
uniform vec3 light_vector;
uniform vec3 cam_position;

// Note: we use the layout stuff instead of glBindAttribLocation
layout(location = 0) in vec3 in_position; // coordinates of the vertex
layout(location = 1) in vec4 in_color; // color of the vertex
layout(location = 3) in vec2 in_v_texcoord; // texture coordinates

out vec4 ex_color; // output color
out vec2 ex_tex_coord;

void main(void) {
	ex_color = in_color;

	// set final vertex position
	gl_Position = mvp * vec4(in_position, 1.0);
	
	ex_tex_coord=in_v_texcoord;
	
}

/*
uniform mat4 mvp;
uniform mat4 model_matrix; 
uniform mat4 normal_matrix;

// Note: we use the layout stuff instead of glBindAttribLocation
layout(location = 0) in vec3 in_position; // coorsinates of the vertex
layout(location = 1) in vec4 in_color; // color of the vertex
layout(location = 2) in vec3 in_v_normal; // vertex normal
layout(location = 3) in vec2 in_v_texcoord; // texture coordinates

out vec4 ex_position; 
//out vec4 ex_color; // output color
//out vec4 ex_normal; // output vertex_normal
out vec2 ex_tex_coord;

void main(void) {
	// set vertex color
	vec3 temp_normal=normalize(mat3(normal_matrix)*in_v_normal);
	//ex_normal = vec4(temp_normal, 1.0);
	//ex_color = vec4(in_color);
	// set final vertex position
	gl_Position = mvp * vec4(in_position, 1.0);
	ex_position = model_matrix * vec4(in_position, 1.0);
	ex_tex_coord=in_v_texcoord;
}

*/