#version 330 core

uniform vec4 texcoord_limit;

uniform vec3 ambient_light_color;
uniform vec3 diffuse_light_color;

uniform float ambient_intenisty;
uniform float diffuse_intenisty;
uniform sampler2D dif_tex;
uniform sampler2D es_tex;

in vec4 ex_geom_color;

layout (location=0) out vec4 out_color;
layout (location=1) out vec4 out_color_glow;
//out vec4 out_color_glow;

in vec2 ex_geom_tex_coord;

float inv_log2 = 1.4426950;

void main(void)
{
	float I_A = ambient_intenisty;
	float I_D = diffuse_intenisty;
	vec2 tex_coord=vec2(texcoord_limit.x+(ex_geom_tex_coord.x*texcoord_limit.z),texcoord_limit.y+(ex_geom_tex_coord.y*texcoord_limit.w));
	vec4 color=texture2D(dif_tex,tex_coord);
	vec4 emitspec=texture2D(es_tex,tex_coord);
	
	float I_ambdiff = I_D*I_A;
	
	float I_l_diff = I_D*I_A;

	float I_diff = I_ambdiff + I_l_diff;
	I_diff = (1-I_diff)*emitspec.x+I_diff;
	
	vec3 temp_color = (color * I_diff).xyz;
	
	vec4 normal_out = vec4(clamp(temp_color.x, 0.0,1.0), clamp(temp_color.y, 0.0,1.0), clamp(temp_color.z, 0.0,1.0), clamp(color.w, 0.0,1.0));
	out_color = normal_out;
	if (emitspec.x == 0) {
		out_color_glow = vec4(0,0,0,1);
	} else {
		out_color_glow = out_color;
		out_color_glow.x *= emitspec.x;
		out_color_glow.y *= emitspec.x;
		out_color_glow.z *= emitspec.x;
		out_color_glow.w *= emitspec.x;
	}
}
