#version 330 core

uniform vec4 texcoord_limit;

uniform vec3 ambient_light_color;
uniform vec3 diffuse_light_color;

uniform vec3 cam_position;

uniform float ambient_intenisty;
uniform float diffuse_intenisty;
uniform float specular_intenisty;
uniform float specular_exponent;
uniform sampler2D dif_tex;
uniform sampler2D n_tex;
uniform sampler2D es_tex;
uniform sampler2D shadow_tex;

in vec4 ex_geom_light_vector;
in vec4 ex_geom_eye_vector;

in vec4 ex_geom_color;

in vec4 ex_shadow_pos;

in vec4 ex_geom_normal;

in vec4 ex_geom_shadow_pos;

layout (location=0) out vec4 out_color;
layout (location=1) out vec4 out_color_glow;

in vec2 ex_geom_tex_coord;

float inv_log2 = 1.4426950;

void main(void)
{
	float I_A = ambient_intenisty;
	float I_D = diffuse_intenisty;
	float I_S = specular_intenisty;
	float N_S = specular_exponent;
	
	
	
	vec2 tex_coord=vec2(texcoord_limit.x+(ex_geom_tex_coord.x*texcoord_limit.z),texcoord_limit.y+(ex_geom_tex_coord.y*texcoord_limit.w));
	vec4 color=texture2D(dif_tex,tex_coord);
	vec4 emitspec=texture2D(es_tex,tex_coord);
	
	vec3 normal= 8.0*texture2D(n_tex,tex_coord).xyz - vec3(4.0f);

	vec3 normalized_normal = normalize(normal);
	//float shadowfactor = 1.0;
	//float shadow_depth=(texture2D(shadow_tex,ex_geom_shadow_pos.xy)).x;
	float bias = 0.001*tan(acos(dot(normalized_normal,normalize(ex_geom_light_vector.xyz))));
	bias = clamp(bias, 0,0.01);
	//if(shadow_depth<ex_geom_shadow_pos.z-bias){
	//	shadowfactor=0.0;
	//}
	
	float I_ambdiff = I_D*I_A;
	
	float anglefactor = dot(normal,ex_geom_light_vector.xyz);
	if (anglefactor < 0) {
		anglefactor = 0;
	}
	float I_l_diff = I_D *anglefactor;//*shadowfactor;

	float I_diff = I_ambdiff + I_l_diff;
	I_diff = (1-I_diff)*emitspec.x+I_diff;
	
	vec3 H = normalize((ex_geom_light_vector.xyz)+ex_geom_eye_vector.xyz);
	float w = dot(normalized_normal, H);
	if (w<0) {
		w = 0;
	}
	
	float I_spec = I_S*emitspec.y*pow(w, N_S);//*shadowfactor;
	
	if (I_spec != I_spec) {
		out_color = vec4(1.0,1.0,1.0,1.0);
		return;
	}
	//float I = I_diff + I_spec;//*shadowfactor;
	
	vec3 temp_color = (color * I_diff + color*I_spec).xyz;
	
	vec4 normal_out = vec4(clamp(temp_color.x, 0.0,1.0), clamp(temp_color.y, 0.0,1.0), clamp(temp_color.z, 0.0,1.0), clamp(color.w, 0.0,1.0));
	out_color = normal_out;
	if (emitspec.x == 0) {
		out_color_glow = vec4(0,0,0,1);
	} else {
		out_color_glow = normal_out;
		out_color_glow.x *= emitspec.x;
		out_color_glow.y *= emitspec.x;
		out_color_glow.z *= emitspec.x;
		out_color_glow.w *= emitspec.x;
	}
}