#version 330 core

uniform mat4 mvp;
uniform mat4 model_matrix; 
uniform mat4 normal_matrix;
uniform mat4 depth_mvp;
uniform vec3 light_vector;
uniform vec3 cam_position;

// Note: we use the layout stuff instead of glBindAttribLocation
layout(location = 0) in vec3 in_position; // coordinates of the vertex
layout(location = 1) in vec4 in_color; // color of the vertex
layout(location = 2) in vec3 in_v_normal; // vertex normal
layout(location = 3) in vec2 in_v_texcoord; // texture coordinates
layout(location = 4) in vec3 in_v_tangent; // vertex tangent
layout(location = 5) in vec3 in_v_bitangent; // vertex bitangent

out vec4 ex_color; // output color
out vec4 ex_normal; // output vertex_normal
out vec4 ex_light_vector;
out vec4 ex_eye_vector;
out vec4 ex_shadow_pos;
out vec2 ex_tex_coord;

void main(void) {
	ex_color = in_color;
	vec3 temp_normal=normalize(mat3(normal_matrix)*in_v_normal);
	//vec3 temp_light=normalize(mat3(normal_matrix)*light_vector);
	vec3 temp_light=normalize(light_vector);
	
	vec3 n = normalize(mat3(normal_matrix)*in_v_normal);
	vec3 t = normalize(mat3(normal_matrix)*in_v_tangent);
	vec3 b = normalize(cross(t, n));
	
	mat3 tangent_space_matrix;
	tangent_space_matrix[0][0] = t.x;
	tangent_space_matrix[1][0] = t.y;
	tangent_space_matrix[2][0] = t.z;
	
	tangent_space_matrix[0][1] = b.x;
	tangent_space_matrix[1][1] = b.y;
	tangent_space_matrix[2][1] = b.z;
	
	tangent_space_matrix[0][2] = n.x;
	tangent_space_matrix[1][2] = n.y;
	tangent_space_matrix[2][2] = n.z;
	
	//ex_light_vector = vec4(dot(light_vector, t), dot(light_vector, b),dot(light_vector, n), 1.0);
	temp_normal = tangent_space_matrix*temp_normal;
	temp_light = tangent_space_matrix*temp_light;
	ex_light_vector = vec4(temp_light, 1.0f);
	ex_normal = vec4(temp_normal, 1.0);
	
	

	// set final vertex position
	gl_Position = mvp * vec4(in_position, 1.0);


	ex_shadow_pos= depth_mvp * vec4(in_position, 1.0);
	
	vec3 tmp = gl_Position.xyz-cam_position;
	tmp = normalize(tangent_space_matrix*tmp);
	ex_eye_vector = vec4(tmp,1.0f);
	
	ex_tex_coord=in_v_texcoord;

	
}