#version 330 core

#extension EXT_geometry_shader4:enable

uniform mat4 mvp;
uniform mat4 model_matrix; 
uniform mat4 normal_matrix;

layout(triangles) in;
layout(triangle_strip, max_vertices=3) out;


in vec4 ex_color[]; // output color
in vec4 ex_normal[]; // output vertex_normal
in vec4 ex_light_vector[]; // input light vector
in vec4 ex_eye_vector[]; // input eye vector
in vec4 ex_shadow_pos[];
in vec2 ex_tex_coord[];

out vec4 ex_geom_color; // output color
out vec4 ex_geom_normal; // output vertex_normal
out vec4 ex_geom_light_vector; // output light vector
out vec4 ex_geom_eye_vector; // output eye vector
out vec2 ex_geom_tex_coord;
out vec4 ex_geom_shadow_pos;


 void main()
{
  for(int i = 0; i < gl_VerticesIn; i++)
  {

	ex_geom_normal = ex_normal[i];
	ex_geom_light_vector = ex_light_vector[i];
	ex_geom_eye_vector = ex_eye_vector[i]; // why the everliving f** cant this be before ex_geom_tex_coord...?
	ex_geom_tex_coord = ex_tex_coord[i];
	ex_geom_shadow_pos=ex_shadow_pos[i];
	
	ex_geom_color = ex_color[i];
	gl_Position = gl_in[i].gl_Position;
    // done with the vertex
    EmitVertex();
  }
  EndPrimitive();
}