#version 330 core

uniform vec4 texcoord_limit;

uniform vec3 ambient_light_color;
uniform vec3 diffuse_light_color;

uniform vec3 cam_position;

uniform float ambient_intenisty;
uniform float diffuse_intenisty;
uniform float specular_intenisty;
uniform float specular_exponent;

uniform int shadow_map_width;
uniform int shadow_map_height;

uniform sampler2D dif_tex;
uniform sampler2D n_tex;
uniform sampler2D es_tex;

uniform sampler2DShadow shadow_tex_0;
uniform sampler2DShadow shadow_tex_1;
uniform sampler2DShadow shadow_tex_2;

in vec4 ex_geom_light_vector;
in vec4 ex_geom_eye_vector;

in vec4 ex_geom_color;

in vec4 ex_shadow_pos;

in vec4 ex_geom_normal;

in vec4 ex_geom_shadow_pos;

layout (location=0) out vec4 out_color;
layout (location=1) out vec4 out_color_glow;

in vec2 ex_geom_tex_coord;

float inv_log2 = 1.4426950;

void main(void)
{
	float I_A = ambient_intenisty;
	float I_D = diffuse_intenisty;
	float I_S = specular_intenisty;
	float N_S = specular_exponent;
	
	
	
	vec2 tex_coord=vec2(texcoord_limit.x+(ex_geom_tex_coord.x*texcoord_limit.z),texcoord_limit.y+(ex_geom_tex_coord.y*texcoord_limit.w));
	vec4 color=texture2D(dif_tex,tex_coord);
	vec4 emitspec=texture2D(es_tex,tex_coord);
	
	vec3 normal= 8.0*texture2D(n_tex,tex_coord).xyz - vec3(4.0f);
	//float temp = normal.x;
	//normal.x = normal.y;
	//normal.y = temp;
	//normal.x = -normal.x;
	//normal.y = -normal.y;
	//normal.z = -normal.z;
	vec3 normalized_normal = normalize(normal);
	
	vec4 new_shadow_pos=ex_geom_shadow_pos;	
	
	float delta_x=1.0/shadow_map_width;
	float delta_y=1.0/shadow_map_height;
	float s1,s2,s3,s4,s5,s6,s7,s8,s9;
	
	if(new_shadow_pos.x<0.5+1.0f/32.0f&&new_shadow_pos.x>0.5-1.0f/32.0f&&new_shadow_pos.y<0.5+1.0f/32.0f&&new_shadow_pos.y>0.5-1.0f/32.0f){
		new_shadow_pos.xy = (new_shadow_pos.xy-vec2(0.5,0.5)) * 16 +vec2(0.5,0.5);
		
		s1 =textureProj(shadow_tex_2,new_shadow_pos);
		s2 =textureProj(shadow_tex_2,new_shadow_pos+vec4(delta_x,0,0,0));
		s3 =textureProj(shadow_tex_2,new_shadow_pos+vec4(-delta_x,0,0,0));
		s4 =textureProj(shadow_tex_2,new_shadow_pos+vec4(0,delta_y,0,0));
		s5 =textureProj(shadow_tex_2,new_shadow_pos+vec4(-0,-delta_y,0,0));
		s6 =textureProj(shadow_tex_2,new_shadow_pos+vec4(delta_x,delta_y,0,0));
		s7 =textureProj(shadow_tex_2,new_shadow_pos+vec4(-delta_x,delta_y,0,0));
		s8 =textureProj(shadow_tex_2,new_shadow_pos+vec4(delta_x,-delta_y,0,0));
		s9 =textureProj(shadow_tex_2,new_shadow_pos+vec4(-delta_x,-delta_y,0,0));
	}else if(new_shadow_pos.x<0.5+1.0f/8.0f&&new_shadow_pos.x>0.5-1.0f/8.0f&&new_shadow_pos.y<0.5+1.0f/8.0f&&new_shadow_pos.y>0.5-1.0f/8.0f){
		new_shadow_pos.xy = (new_shadow_pos.xy-vec2(0.5,0.5)) * 4 +vec2(0.5,0.5);
		
		s1 =textureProj(shadow_tex_1,new_shadow_pos);
		s2 =textureProj(shadow_tex_1,new_shadow_pos+vec4(delta_x,0,0,0));
		s3 =textureProj(shadow_tex_1,new_shadow_pos+vec4(-delta_x,0,0,0));
		s4 =textureProj(shadow_tex_1,new_shadow_pos+vec4(0,delta_y,0,0));
		s5 =textureProj(shadow_tex_1,new_shadow_pos+vec4(-0,-delta_y,0,0));
		s6 =textureProj(shadow_tex_1,new_shadow_pos+vec4(delta_x,delta_y,0,0));
		s7 =textureProj(shadow_tex_1,new_shadow_pos+vec4(-delta_x,delta_y,0,0));
		s8 =textureProj(shadow_tex_1,new_shadow_pos+vec4(delta_x,-delta_y,0,0));
		s9 =textureProj(shadow_tex_1,new_shadow_pos+vec4(-delta_x,-delta_y,0,0));
	}else{
		s1 =textureProj(shadow_tex_0,new_shadow_pos);
		s2 =textureProj(shadow_tex_0,new_shadow_pos+vec4(delta_x,0,0,0));
		s3 =textureProj(shadow_tex_0,new_shadow_pos+vec4(-delta_x,0,0,0));
		s4 =textureProj(shadow_tex_0,new_shadow_pos+vec4(0,delta_y,0,0));
		s5 =textureProj(shadow_tex_0,new_shadow_pos+vec4(-0,-delta_y,0,0));
		s6 =textureProj(shadow_tex_0,new_shadow_pos+vec4(delta_x,delta_y,0,0));
		s7 =textureProj(shadow_tex_0,new_shadow_pos+vec4(-delta_x,delta_y,0,0));
		s8 =textureProj(shadow_tex_0,new_shadow_pos+vec4(delta_x,-delta_y,0,0));
		s9 =textureProj(shadow_tex_0,new_shadow_pos+vec4(-delta_x,-delta_y,0,0));
	}

	float shadowfactor=(4*s1+2*s2+2*s3+2*s4+2*s5+s6+s7+s8+s9)*0.0625;///16;
	
	float bias=1+tan(acos(dot(normalized_normal,normalize(ex_geom_light_vector.xyz))));
	bias=clamp(bias,0.0,10.0);
	
	shadowfactor=clamp(shadowfactor*bias,0, 1.0);
	float I_ambdiff = I_D*I_A;
	
	float anglefactor = dot(normal,ex_geom_light_vector.xyz);
	if (anglefactor < 0) {
		anglefactor = 0;
	}
	float I_l_diff = I_D *anglefactor*shadowfactor;

	float I_diff = I_ambdiff + I_l_diff;
	I_diff = (1-I_diff)*emitspec.x+I_diff;
	
	vec3 H = normalize((ex_geom_light_vector.xyz)+ex_geom_eye_vector.xyz);
	float w = dot(normalized_normal, H);
	if (w<0) {
		w = 0;
	}
	
	float I_spec = I_S*emitspec.y*pow(w, N_S)*shadowfactor;
	
	if (I_spec != I_spec) {
		out_color = vec4(1.0,1.0,1.0,1.0);
		return;
	}
	//float I = I_diff + I_spec*shadowfactor;
	
	vec3 temp_color = (color * I_diff + color*I_spec*shadowfactor).xyz;
	vec4 normal_out = vec4(clamp(temp_color.x, 0.0,1.0), clamp(temp_color.y, 0.0,1.0), clamp(temp_color.z, 0.0,1.0), clamp(color.w, 0.0,1.0));
	out_color = normal_out;
	if (emitspec.x == 0) {
		out_color_glow = vec4(0,0,0,1);
	} else {
		out_color_glow = out_color;
		out_color_glow.x *= emitspec.x;
		out_color_glow.y *= emitspec.x;
		out_color_glow.z *= emitspec.x;
		out_color_glow.w *= emitspec.x;
	}
	
}
