#version 330 core
uniform sampler2D dif_tex;
uniform sampler2D orig_glow_tex;
uniform sampler2D glow_tex;
uniform sampler2D bloom_tex;


uniform float delta_x;
uniform float delta_y;

in vec2 ex_geom_tex_coord;
in vec4 ex_geom_color;

layout (location=0) out vec4 out_color;


void main(void) {
	float dy_bloom = delta_y;
	float dy_glow = delta_y;
	
	float dy_glow_0_5 = dy_glow*0.5;
	float dy_glow_1_5 = dy_glow+dy_glow_0_5;
	float dy_glow_2 = dy_glow+dy_glow;
	float dy_glow_2_5 = dy_glow_2+dy_glow_0_5;
	float dy_glow_3 = dy_glow_2+dy_glow;
	float dy_glow_3_5 = dy_glow_2+dy_glow+dy_glow_0_5;
	float dy_glow_4 = dy_glow_2+dy_glow_2;
	
	float dy_bloom_0_5 = dy_bloom*0.5;
	float dy_bloom_1_5 = dy_bloom+dy_bloom_0_5;
	float dy_bloom_2 = dy_bloom+dy_bloom;
	float dy_bloom_2_5 = dy_bloom_2+dy_bloom_0_5;
	float dy_bloom_3 = dy_bloom_2+dy_bloom;
	float dy_bloom_3_5 = dy_bloom_2+dy_bloom+dy_bloom_0_5;
	float dy_bloom_4 = dy_bloom_2+dy_bloom_2;
	
	//float delta_x = 1.0f/1024.0f;
	vec4 color1=texture2D(dif_tex,ex_geom_tex_coord);
	vec4 color2=texture2D(glow_tex,ex_geom_tex_coord);
	vec4 color3=texture2D(bloom_tex,ex_geom_tex_coord);
	vec4 color4=texture2D(orig_glow_tex,ex_geom_tex_coord);
	
	
	vec4 sum_glow = vec4(0);
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_4))*0.015;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_3_5))*0.025;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_3))*0.03;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_2_5))*0.04;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_2))*0.05;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_1_5))*0.07;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow))*0.09;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_glow_0_5))*0.11;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y))*0.14;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_0_5))*0.11;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow))*0.09;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_1_5))*0.07;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_2))*0.05;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_2_5))*0.04;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_3))*0.03;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_3_5))*0.025;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_glow_4))*0.015;
	out_color = sum_glow;
	
	vec4 sum_bloom = vec4(0);
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_4))*0.015;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_3_5))*0.025;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_3))*0.03;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_2_5))*0.04;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_2))*0.05;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_1_5))*0.07;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom))*0.09;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y - dy_bloom_0_5))*0.11;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y))*0.14;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_0_5))*0.11;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom))*0.09;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_1_5))*0.07;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_2))*0.05;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_2_5))*0.04;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_3))*0.03;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_3_5))*0.025;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y + dy_bloom_4))*0.015;
	
	out_color = sum_bloom;
	out_color = color1;

	out_color.x = (out_color.x +(sum_glow.x*1.2));
	out_color.y = (out_color.y +(sum_glow.y*1.2));
	out_color.z = (out_color.z +(sum_glow.z*1.2));

	out_color.x = (out_color.x+(sum_bloom.x*sum_bloom.w)*0.8);
	out_color.y = (out_color.y+(sum_bloom.y*sum_bloom.w)*0.8);
	out_color.z = (out_color.z+(sum_bloom.z*sum_bloom.w)*0.8);

	//out_color = color3;
	out_color.a = 1.0;
}