#version 330 core
uniform sampler2D glow_tex;
uniform sampler2D bloom_tex;


uniform float delta_x;
uniform float delta_y;

in vec2 ex_geom_tex_coord;
in vec4 ex_geom_color;

layout (location=0) out vec4 out_blur_glow;
layout (location=1) out vec4 out_blur_bloom;


void main(void) {
	float dx_bloom = delta_x; 
	float dx_glow = delta_x;
	
	float dx_glow_0_5 = dx_glow*0.5;
	float dx_glow_1_5 = dx_glow+dx_glow_0_5;
	float dx_glow_2 = dx_glow+dx_glow;
	float dx_glow_2_5 = dx_glow_2+dx_glow_0_5;
	float dx_glow_3 = dx_glow_2+dx_glow;
	float dx_glow_3_5 = dx_glow_2+dx_glow+dx_glow_0_5;
	float dx_glow_4 = dx_glow_2+dx_glow_2;
	
	float dx_bloom_0_5 = dx_bloom*0.5;
	float dx_bloom_1_5 = dx_bloom+dx_bloom_0_5;
	float dx_bloom_2 = dx_bloom+dx_bloom;
	float dx_bloom_2_5 = dx_bloom_2+dx_bloom_0_5;
	float dx_bloom_3 = dx_bloom_2+dx_bloom;
	float dx_bloom_3_5 = dx_bloom_2+dx_bloom+dx_bloom_0_5;
	float dx_bloom_4 = dx_bloom_2+dx_bloom_2;
	
	vec4 color1=texture2D(glow_tex,ex_geom_tex_coord);
	vec4 color2=texture2D(bloom_tex,ex_geom_tex_coord);
	
	
	vec4 sum_glow = vec4(0);
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_4, ex_geom_tex_coord.y))*0.015;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_3_5, ex_geom_tex_coord.y))*0.025;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_3, ex_geom_tex_coord.y))*0.03;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_2_5, ex_geom_tex_coord.y))*0.04;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_2, ex_geom_tex_coord.y))*0.05;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_1_5, ex_geom_tex_coord.y))*0.07;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow, ex_geom_tex_coord.y))*0.09;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x - dx_glow_0_5, ex_geom_tex_coord.y))*0.11;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y))*0.14;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_0_5, ex_geom_tex_coord.y))*0.11;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow, ex_geom_tex_coord.y))*0.09;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_1_5, ex_geom_tex_coord.y))*0.07;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_2, ex_geom_tex_coord.y))*0.05;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_2_5, ex_geom_tex_coord.y))*0.04;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_3, ex_geom_tex_coord.y))*0.03;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_3_5, ex_geom_tex_coord.y))*0.025;
	sum_glow += texture2D(glow_tex,vec2(ex_geom_tex_coord.x + dx_glow_4, ex_geom_tex_coord.y))*0.015;
	out_blur_glow = sum_glow;
	
	vec4 sum_bloom = vec4(0);
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_4, ex_geom_tex_coord.y))*0.015;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_3_5, ex_geom_tex_coord.y))*0.025;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_3, ex_geom_tex_coord.y))*0.03;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_2_5, ex_geom_tex_coord.y))*0.04;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_2, ex_geom_tex_coord.y))*0.05;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_1_5, ex_geom_tex_coord.y))*0.07;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom, ex_geom_tex_coord.y))*0.09;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x - dx_bloom_0_5, ex_geom_tex_coord.y))*0.11;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x, ex_geom_tex_coord.y))*0.14;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_0_5, ex_geom_tex_coord.y))*0.11;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom, ex_geom_tex_coord.y))*0.09;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_1_5, ex_geom_tex_coord.y))*0.07;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_2, ex_geom_tex_coord.y))*0.05;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_2_5, ex_geom_tex_coord.y))*0.04;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_3, ex_geom_tex_coord.y))*0.03;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_3_5, ex_geom_tex_coord.y))*0.025;
	sum_bloom += texture2D(bloom_tex,vec2(ex_geom_tex_coord.x + dx_bloom_4, ex_geom_tex_coord.y))*0.015;
	
	out_blur_bloom = sum_bloom;
}