#version 330 core
uniform sampler2D dif_tex;
uniform sampler2D glow_tex;

uniform vec4 texcoord;

in vec2 ex_geom_tex_coord;
in vec4 ex_geom_color;


layout (location=0)out vec4 out_glow;
layout (location=1)out vec4 out_bloom;
float a = 0;
float b = 1;
float mult = 1;
vec4 tone1;
vec4 tone2;
vec4 tone3;
vec4 tone4;
vec4 tone5;
void main(void) {
	vec4 color1=texture2D(dif_tex,ex_geom_tex_coord);
	vec4 color2=texture2D(glow_tex,ex_geom_tex_coord);
	
	if (color2.x > 0.0 || color2.y > 0.0 || color2.z > 0.0) {
		out_glow = color2;
		out_glow.a = 1.0;
		out_bloom = vec4(0,0,0,0);
		float max = color2.x;
		if (color2.y > color2.x) {
			max = color2.y;
		}
		if (color2.z > color2.x) {
			max = color2.z;
		}
		if (max < 0.4) {
			out_glow.a = max;
		}
		return;
	} else {
		out_glow = vec4(0.0, 0.0, 0.0, 0.0);
	}
	
	a = 0.5;
	b = 1.0;
	if (color2.x == 0 && color2.y == 0 && color2.z == 0) {
		tone1 = vec4((clamp(color1.x, a,b)),
			(clamp(color1.y, a,b)),
			(clamp(color1.z, a,b)),
			(color1.x > a || color1.y > a || color1.z > a) ? 1.0 : 0.0);
		out_bloom = clamp(tone1*1.9,0,1);
		//out_bloom.x = clamp(tone1.x*1.0,0,1);
		//out_bloom.y = clamp(tone1.y*1.0,0,1);
		//out_bloom.z = clamp(tone1.z*1.0,0,1);
		//out_bloom.a = 1;
	} else {
		tone1 = vec4(0,0,0,0);
		out_bloom = vec4(0,0,0,0);
	}
	
	
	//out_glow = out_bloom;
	//out_bloom = color1;
}