#version 330 core

layout(location = 0) in vec3 in_position; // coordinates of the vertex
uniform vec2 halfwidthheight;

uniform vec3 normalized_y;

out vec2 ex_halfwidthheight;

uniform mat4 mvp;
void main(void) {
	gl_Position = mvp*vec4(in_position, 1);
	if (gl_Position.w != 1.0f) {
		gl_Position.x /= gl_Position.w;
		gl_Position.y /= gl_Position.w;
		gl_Position.z /= gl_Position.w;
		gl_Position.w = 1.0f;
	}
	vec4 w = mvp*vec4(normalized_y.x*halfwidthheight.x,
					normalized_y.y*halfwidthheight.x,
					normalized_y.z*halfwidthheight.x,
					1);
	vec4 h = mvp*vec4(normalized_y.x*halfwidthheight.y,
					normalized_y.y*halfwidthheight.y,
					normalized_y.z*halfwidthheight.y,
					1);
	if (w.w != 1.0f) {
		w.x /= w.w;
		w.y /= w.w;
		w.z /= w.w;
		w.w = 1.0f;
	}
	if (h.w != 1.0f) {
		h.x /= h.w;
		h.y /= h.w;
		h.z /= h.w;
		h.w = 1.0f;
	}
	ex_halfwidthheight.x = length( vec3(gl_Position.x,gl_Position.y,gl_Position.z)-vec3(w.x,w.y,w.z) );
	ex_halfwidthheight.y = length( vec3(gl_Position.x,gl_Position.y,gl_Position.z)-vec3(h.x,h.y,h.z) );
}