#version 330 core

#extension EXT_geometry_shader4:enable

layout(points) in;
layout(triangle_strip , max_vertices=4) out;

uniform vec4 texcoord;

uniform mat4 mvp;

in vec2 ex_halfwidthheight[1];

out vec4 ex_geom_normal; // output vertex_normal
out vec2 ex_geom_tex_coord; // output texture coordinate

 void main() {
	
	
	
	vec4 norm = vec4(0.0f,0.0f,1.0f,1.0f);
	
	for(int i = 0; i < gl_VerticesIn; i++) {
	float halfwidth = ex_halfwidthheight[i].x;
	float halfheight = ex_halfwidthheight[i].y;
		/*gl_Position = vec4(0,0,0,1);
		ex_geom_normal = norm;
		ex_geom_tex_coord = vec2(0,0);
		EmitVertex();
		gl_Position = vec4(0.2,0,0,1);
		ex_geom_tex_coord = vec2(1,0);
		ex_geom_normal = norm;
		EmitVertex();
		gl_Position = vec4(0.2,0.2,0,1);
		ex_geom_tex_coord = vec2(1,1);
		ex_geom_normal = norm;
		EmitVertex();
		gl_Position = vec4(0,0.2,0,1);
		ex_geom_tex_coord = vec2(0,1);
		ex_geom_normal = norm;
		EmitVertex();
		EndPrimitive();*/
		vec2 topleft = vec2(gl_in[i].gl_Position.x-halfwidth, gl_in[i].gl_Position.y-halfheight);
		vec2 bottomright = vec2(topleft.x+halfwidth+halfwidth, topleft.y+halfheight+halfheight); 
		vec4 p1 = vec4(topleft.x, topleft.y,gl_in[i].gl_Position.z,1);
		vec4 p2 = vec4(bottomright.x, topleft.y,gl_in[i].gl_Position.z,1);
		vec4 p3 = vec4(topleft.x, bottomright.y,gl_in[i].gl_Position.z,1);
		vec4 p4 = vec4(bottomright.x, bottomright.y,gl_in[i].gl_Position.z,1);
		vec2 t1 = vec2(texcoord.x,texcoord.y);
		vec2 t2 = vec2(texcoord.x+texcoord.z,texcoord.y);
		vec2 t3 = vec2(texcoord.x,texcoord.y+texcoord.w);
		vec2 t4 = vec2(texcoord.x+texcoord.z,texcoord.y+texcoord.w);
		
		gl_Position = p1;
		ex_geom_tex_coord = t1;
		ex_geom_normal = norm;
		EmitVertex();
		gl_Position = p2;
		ex_geom_tex_coord = t2;
		ex_geom_normal = norm;
		EmitVertex();
		gl_Position = p3;
		ex_geom_tex_coord = t3;
		ex_geom_normal = norm;
		EmitVertex();
		gl_Position = p4;
		ex_geom_tex_coord = t4;
		ex_geom_normal = norm;
		EmitVertex();
		EndPrimitive();
	}
  
}