#version 330 core
#extension GL_EXT_geometry_shader4 : enable

//texcoord width/height of a quadrant in the textere
uniform float tex_width;
uniform float tex_height;

layout(points) in;
layout(triangle_strip, max_vertices=4) out;

out vec2 ex_geom_tex_coord;

in VertexData{ 
	vec2 indices;
	vec2 size;} ex_vertex[];

 void main()
{
	for(int i = 0; i < gl_VerticesIn; i++){
		{
			gl_Position = vec4(gl_Position.x,gl_Position.y,0,0);
			ex_geom_tex_coord = vec2(ex_vertex[i].indices.x * tex_width , ex_vertex[i].indices.y * tex_height);
			EmitVertex();
		}
		{
			gl_Position = vec4(gl_Position.x+ex_vertex[i].size.x,gl_Position.y,0,0);
			ex_geom_tex_coord = vec2(ex_vertex[i].indices.x * tex_width + tex_width , ex_vertex[i].indices.y * tex_height);
			EmitVertex();
		}
		{
			gl_Position = vec4(gl_Position.x,gl_Position.y+ex_vertex[i].size.y,0,0);
			ex_geom_tex_coord = vec2(ex_vertex[i].indices.x * tex_width , ex_vertex[i].indices.y * tex_height + tex_height);
			EmitVertex();
		}
		{
			gl_Position = vec4(gl_Position.x+ex_vertex[i].size.x,gl_Position.y+ex_vertex[i].size.y,0,0);
			ex_geom_tex_coord = vec2(ex_vertex[i].indices.x * tex_width + tex_width , ex_vertex[i].indices.y * tex_height + tex_height);
			EmitVertex();
		}
	}
  EndPrimitive();
}