#version 150

// modelview & projection matrices
uniform mat4 projection;
uniform mat4 modelview;
// mapsize needed for generating alphamap tex coords
uniform float mapsize;
uniform int time;
// the vertex position & normal vector
in vec4 vertex;
in vec3 normal;
// the calculated texture cordinates
out vec2 terrain_texcoord;
out vec2 alpha_texcoord;
// the transformed light direction (into tangent space)
out vec3 t_dir; 

void main(void)
{
	// calculate the light direction of our only directional light in tangent space
	vec3 l_dir = normalize(vec3(-1.0,-1.0,-1.0));
		//vec3 l_dir = normalize(vec3(1.0*cos(time/2000.0),1.0*sin(time/2000.0),0.2)); // uncomment for rotating light source
	vec3 c1 = cross(normal, vec3(0.0, 0.0, 1.0)); 
	vec3 c2 = cross(normal, vec3(0.0, 1.0, 0.0)); 
	vec3 t;
	if (length(c1) > length(c2)) t = c1; else t = c2;
	vec3 b = cross(t, normal);
	t_dir.x = dot(l_dir, t);
	t_dir.y = dot(l_dir, b);
	t_dir.z = dot(l_dir, normal);
	// calculate the texture coordinates for the terrain texture (tiles every 4 x 4 units)
	terrain_texcoord = vec2(vertex.x/4.0,vertex.y/4.0);
	alpha_texcoord = vec2(vertex.x/mapsize,vertex.y/mapsize);
	// calculate transformed vertex position
	gl_Position = projection * modelview * vertex;	
}