#version 150

// the terrain textures
uniform sampler2D terrain0;
uniform sampler2D terrain1;
uniform sampler2D terrain2;
uniform sampler2D terrain3;
uniform sampler2D normal0;
uniform sampler2D normal1;
uniform sampler2D normal2;
uniform sampler2D normal3;
// the blending texture
uniform sampler2D alpha;
// fow texture
uniform sampler2D fow;
// the calculated texture cordinates
in vec2 terrain_texcoord;
in vec2 alpha_texcoord;
// the transformed light direction
in vec3 t_dir;
// the final calculated fragment color (OUTPUT)
out vec4 color;

void main(void)
{
	// calculate ambient intensity
	float ambient = 0.15;
	float diffusefactor = 0.2 + 2.0*0.65*(0.5-texture2D(fow, alpha_texcoord).a);
	// calculate diffuse intensity
	vec3 normal_ts = normalize(vec3(texture2D(normal0, terrain_texcoord) * 2.0 - 1.0));
	float diffuse = diffusefactor * clamp(dot(normal_ts, t_dir), 0.0, 1.0);
	vec4 color0 = (ambient + diffuse) * texture2D(terrain0, terrain_texcoord);
	normal_ts = normalize(vec3(texture2D(normal1, terrain_texcoord) * 2.0 - 1.0));
	diffuse = diffusefactor * clamp(dot(normal_ts, t_dir), 0.0, 1.0);
	vec4 color1 = (ambient + diffuse) * texture2D(terrain1, terrain_texcoord);
	normal_ts = normalize(vec3(texture2D(normal2, terrain_texcoord) * 2.0 - 1.0));
	diffuse = diffusefactor * clamp(dot(normal_ts, t_dir), 0.0, 1.0);
	vec4 color2 = (ambient + diffuse) * texture2D(terrain2, terrain_texcoord);
	normal_ts = normalize(vec3(texture2D(normal3, terrain_texcoord) * 2.0 - 1.0));
	diffuse = diffusefactor * clamp(dot(normal_ts, t_dir), 0.0, 1.0);
	vec4 color3 = (ambient + diffuse) * texture2D(terrain3, terrain_texcoord);
	// calculate final color with alpha textures
	vec3 blend = texture2D(alpha, alpha_texcoord).rgb;
	//vec4 final = ((color0*(1-blend.x)+color1*blend.x)*(1-blend.y)+color2*blend.y)*(1-blend.z)+color3*blend.z;
	vec4 final = mix(mix(mix(color0, color1, blend.x), color2, blend.y), color3, blend.z);
	//vec4 final = color0;
	final.a = 1.0;
	color = final;
}