#version 150

// modelview & projection matrices
uniform mat4 projection;
uniform mat4 modelview;
// parameters for rendering
uniform int time;
uniform int model;
// parameters in case of morph rendering (two models mixed)
uniform int model2;
uniform float mixfactor;
// vertical squishing factor
uniform float vertfactor;
// resolution of current LOD
uniform float resolution;
// some values for noise position
uniform float zfactor;
// incoming vertex mesh
in vec2 vertex;
// outgoing transformed light
out vec3 t_dir;
out float m_x;
out float m_y;
out vec3 pos;

// define pi as this shader needs it a lot lol
const float pi = 3.141593;



vec3 getposition(int model, float x, float y) { 
	vec3 position;
	float radius;
	switch (model) {
		case 7:
			radius = 0.5 * sin(pi * y) * (0.8 + 0.2 * sin(x*pi*12));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;
			break;
		case 6:
			radius = sqrt(0.25-pow(abs(0.5-y), 2)) * (0.8 + 0.2 * sin(x*pi*10));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;
			break;
		case 5:
			radius = sqrt(0.25-pow(abs(0.5-y), 2));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;
			break;
		case 4:
			radius = 0.5 * sin(pi * y) * (0.8 + 0.2 * sin(x*pi*6));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;
			break;
		case 3:
			radius = 0.5 * sin(pi * sqrt(y)) * (0.7 + y*0.3 * sin(x*pi*16));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;			
			break;
		case 2:
			radius = 0.5 * sin(pi * sqrt(y)) * (0.8 + 0.2 * sin(x*pi*6));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;			
			break;
		case 1:
			radius = 0.5 * sin(pi * y);
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;
			break;
		case 0:
		default:
			radius = 0.5 * sin(pi * sqrt(y));
			position.x = radius * cos(x * 2 * pi);
			position.y = radius * sin(x * 2 * pi);
			position.z = -0.5 + y;			
			break;
	}
	return position;
}

void main(void)
{
	vec3 l_dir = normalize(vec3(1.0,1.0,1.0));
	t_dir = (modelview * vec4(l_dir, 0.0)).xyz;	
	// calculate normalized mesh coords
	float mx = vertex.x / resolution;
	float my = vertex.y / (resolution-1.0);
	m_x = mx;
	m_y = my;
	// calculate vertex position
	vec3 position = getposition(model, mx, my);
	
	// do the same thing again for morphing animation
	if (mixfactor > 0.005) {
		vec3 pos = getposition(model2, mx, my);
		float afactor = clamp(mixfactor+0.25*sin(mixfactor*31.415), 0.0, 1.0);
		position = mix(position, pos, afactor);
	} 
	pos = vec3(position.x, position.y, position.z*zfactor);
	// do some squishy animation
	float factor = 1.0 + vertfactor * sin(time / 250.0);
	float deltaz = (factor - 1.0) / 2.0;
	// calculate final vertex pos	
	gl_Position = projection * modelview * vec4(position.x/factor, position.y/factor, position.z*factor+deltaz, 1.0);
}