#version 150

// modelview & projection matrices
uniform mat4 modelview;
// parameters for rendering
uniform int time;
uniform int model;
// the color of the primitive
uniform vec4 tint;
// parameters in case of morph rendering (two models mixed)
uniform int model2;
uniform float mixfactor;
// vertical squishing factor
uniform float vertfactor;

uniform float x, y, z;
// incoming from vert shader
in vec3 t_dir;

in float m_x;
in float m_y;
in vec3 pos;

// the final calculated fragment color (OUTPUT)
out vec4 color;

// define pi as this shader needs it a lot lol
const float pi = 3.141593;

vec3 mynoise() {
	vec3 n;
	n.x = sin(pos.x*23.0+(time+x)/400.0) + sin((time+y)/2805.8) * cos(pos.y*18.8-time/666.6) + sin(pos.z*31.1+(time+y)/266.6);
	n.y = cos(pos.y*19.0+time/200.0) + cos((time+z)/4500.0) * cos(pos.x*17.8+(time+y)/800.0) + cos(pos.z*26.1-time/500.0);
	n.z = sin(pos.z*16.1+(time+x)/400.0) + sin(time/7246.4) * sin(pos.y*24.8+(time+x)/300.0) + sin(pos.x*22.6+(time+z)/600.0);
	return n;
}

vec3 mynoise2() {
	vec3 n;
	n.x = sin(pos.x*35.0+time/310.0) + cos(time/3205.8) * cos(pos.y*28.8-time/666.6) - sin(pos.z*33.1+time/266.6);
	n.y = sin(pos.y*32.0+time/215.0) - cos(time/6211.0) * sin(pos.x*32.8+time/766.0) + cos(pos.z*34.1-time/466.0);
	n.z = cos(pos.z*33.1+time/355.0) + sin(time/4822.4) * cos(pos.y*34.6+time/412.0) - cos(pos.x*29.6+time/688.0);
	return n;
}

vec2 getvertical(int model, float x, float y) {
	vec2 vertical;
	float tmp;
	switch (model) {
		case 5:
		case 6:
			tmp = abs(1-2*y);
			vertical = normalize(vec2(-sign(1-2*y)*tmp, sqrt(1-pow(tmp, 2))));
			break;
		case 1:
		case 4:
		case 7:
			vertical = normalize(vec2(-pi*cos(pi*y),1.0));
			break;
		case 0:
		case 2:
		case 3:
		default:
			tmp = sqrt(y);
			vertical = normalize(vec2(-pi*cos(pi*tmp)/(2*tmp),1.0));
			break;	
	}
	return normalize(vertical);
}

vec2 gethorizontal(int model, float x, float y) {
	vec2 horizontal;
	float dir;
		
	switch (model) {
		case 7:
			dir = x * 2 * pi - 0.45*cos(12*pi*x);
			break;
		case 6:
			dir = x * 2 * pi - 0.45*cos(10*pi*x);
			break;
		case 3:
			dir = x * 2 * pi - 0.35*cos(16*pi*x);
			break;
		case 2:
		case 4:
			dir = x * 2 * pi - 0.55*cos(6*pi*x);
			break;
		case 0:
			dir = x * 2 * pi;
			break;
		default:
			dir = x * 2 * pi;
			break;
	}
	horizontal = vec2(cos(dir), sin(dir));
	return horizontal;
}


void main(void)
{
	// calculate z/h 2D normal vector
	vec2 vertical = getvertical(model, m_x, m_y);
	// calculate x/y 2D normal vector
	vec2 horizontal = gethorizontal(model, m_x, m_y);
	// merge to 3D normal vector
	vec3 normal_ = normalize(vec3(horizontal.x * vertical.y, horizontal.y * vertical.y, vertical.x));
	if (m_y < 0.0001) normal_ = vec3(0.0,0.0,-1.0);
	if (mixfactor > 0.005) {
		vec2 vert = getvertical(model2, m_x, m_y);
		vec2 hor = gethorizontal(model2, m_x, m_y);
		vec3 norm = vec3(hor.x * vert.y, hor.y * vert.y, vert.x);
		float afactor = clamp(mixfactor+0.25*sin(mixfactor*31.415), 0.0, 1.0);
		normal_ = normalize(mix(normal_, norm, afactor));
		normal_.z += abs(sin(time / 500.0 + pi/2.0 + 0.5)) * (0.15 * sin(m_y * 24.0) + 0.07 * sin((m_y+0.3) * 32.0) ); //EXPERIMENTAL
		normal_ = normalize(normal_);
	} 
	if (model == 1 || model == 6 || model == 5 || model == 0)
	normal_ = normalize(normal_+0.055*mynoise()+0.03*mynoise2()); else
	normal_ = normalize(normal_+0.035*mynoise()+0.02*mynoise2());
	float factor = 1.0 + vertfactor * sin(time / 250.0);
	vec3 normal = normalize((modelview * normalize(vec4(normal_.x/factor, normal_.y/factor, normal_.z*factor, 0.0))).xyz);
	
	
	
	float diffuse = 0.8 * clamp(dot(normal, t_dir), 0.0, 1.0);
	
	vec3 r = normalize(reflect(t_dir, normal));
	float specular = pow(clamp(max(dot(r, vec3(0.0, 0.0, -1.0)), 0.0), 0.0, 1.0), 50.0);
	
	color = (0.2 + diffuse) * tint + specular * vec4(1.0,1.0,1.0,1.0);
	color.a = clamp(color.a, 0.60, 0.70);
}