#version 130
precision mediump float;

uniform mat4 perspective;
uniform mat4 view;
uniform mat4 model;

in vec4 vertex;
in vec3 normal;

out vec3 world_normal;
out vec4 world_position;

void main() {
	
	// transform normal into world space
	vec4 normal4 = vec4(normal, 0.0f);
    world_normal = (model * normal4).xyz;
    
    // transform vertex to world-space
    world_position = model * vertex;
    
    // position ouput
	gl_Position = perspective * view * model * vertex;
}
