#version 130
precision mediump float;

//uniform shader-parameters

uniform vec3 light_position;
uniform vec4 light_color;
uniform vec4 ambient_color;
uniform vec4 color;

in vec3 world_normal;
in vec4 world_position;

out vec4 fragColor;

void main() {

	// renormalize and homogenize input variables
	vec3 normal = normalize(world_normal);
   	vec3 position = world_position.xyz / world_position.w;
    
    	// calculate the light-direction
    	vec3 light_dir = normalize(light_position - position);

	float light_dist = sqrt(light_dir.x*light_dir.x + light_dir.y*light_dir.y + light_dir.z*light_dir.z);

	//calculate color
	vec4 frag_color = color;
	
	// calculate lighting
	vec4 ambient = ambient_color * frag_color;
	vec4 diffuse = light_color * max(0.0, dot(normal, light_dir));
    
	// write color to output
	fragColor = ambient + diffuse*(1.0 / (light_dist*light_dist));
}

