#version 130
precision mediump float;

//transformation matrices
uniform mat4 perspective;
uniform mat4 view;
uniform mat4 model;

//needed to compute position in previous frame
uniform mat4 preview;
uniform mat4 prevmodel;

//vertex and texture coordinate
in vec4 vertex;
in vec3 normal;
in vec2 texCoordinates;

//fragment shader inputs
out vec2 texCoord; //take for normal textur 0
out vec4 prev_position; //write to previous position textur
out vec4 curr_position; //write to current position textur

void main(){
	texCoord = texCoordinates;

	curr_position = perspective * view * model * vertex;
	prev_position = perspective * preview * prevmodel* vertex;
	
	// position ouput
	gl_Position = curr_position;
}