#version 130
precision mediump float;

in vec2 texCoord;
in vec4 prev_position;
in vec4 curr_position;

out vec4 fragColor;

void main() {

	//calculate differences
	vec2 curpos = curr_position.xy;
	vec2 prepos = prev_position.xy;

	#define BLUR_VECTOR_SCALE 60.0
	#define SCREEN_SIZE vec2(1024, 768)

	vec2 delta = abs(curpos - prepos) * 0.08;
	delta.x = min(delta.x, 0.05);
	delta.y = min(delta.y, 0.05);

	float DOF_blur = abs(curr_position.z - 0.8);

	//calculate color
	fragColor = vec4(delta, 0.0, 1.0);
}

