#version 130
precision highp float;


uniform sampler2D frame;
uniform sampler2D motion;

in vec2 texCoord;

out vec4 fragColor;

const vec2 poisson[16]=vec2[16](
	vec2(0.007937789, 0.73124397),
	vec2(-0.10177308, -0.6509396),
	vec2(-0.9906806, -0.63400936),
	vec2(-0.5583586, -0.3614012),
	vec2(0.7163085, 0.22836149),
	vec2(-0.65210974, 0.37117887),
	vec2(-0.12714535, 0.112056136),
	vec2(0.48898065, -0.66669613),
	vec2(-0.9744036, 0.9155904),
	vec2(0.9274436, -0.9896486),
	vec2(0.9782181, 0.90990245),
	vec2(0.96427417, -0.25506377),
	vec2(-0.5021933, -0.9712455),
	vec2(0.3091557, -0.17652994),
	vec2(0.4665941, 0.96454906),
	vec2(-0.461774, 0.9360856)
);

void main() {
	
	#define BLUR_VECTOR_SCALE 0.5
	
	int numSamples = 64;

	vec2 vector = (texture(motion,texCoord).xy);
	vector = vector/numSamples;

	vec4 color = vec4(0.0);

	//float radius = texture(motion,texCoord).z * 1;
	
	//for(int i=0;i<16;i++){
	//	color += texture(frame, texCoord + poisson[i]*radius);
	//}
	//color/=16;

	vec2 pos;

	//take full samples first half distance
	for(float i=0;i<numSamples/2;i++){
		pos.x = max(min(vec2(texCoord +(vector*i)).x, 0.9999),0.0);
		pos.y = max(min(vec2(texCoord +(vector*i)).y, 0.9999),0.0);	
		color+= texture(frame, pos);

		pos.x = max(min(vec2(texCoord -(vector*i)).x, 0.9999),0.0);
		pos.y = max(min(vec2(texCoord -(vector*i)).y, 0.9999),0.0);
		color+= texture(frame, pos);
	}

	//take half samples second half distance
	for(float i=numSamples/2;i<numSamples;i++){
		pos.x = max(min(vec2(texCoord +(vector*i)).x, 0.9999),0.0);
		pos.y = max(min(vec2(texCoord +(vector*i)).y, 0.9999),0.0);	
		color+= texture(frame, pos) *0.5;

		pos.x = max(min(vec2(texCoord -(vector*i)).x, 0.9999),0.0);
		pos.y = max(min(vec2(texCoord -(vector*i)).y, 0.9999),0.0);
		color+= texture(frame, pos) *0.5;
	}
	
	fragColor = color/(numSamples *1.5);
}

