// Converts all fragments to grayscale

varying float diffuse;
uniform sampler2D tex;

void main()
{
	vec3 ct,cf;
	vec4 texel;
	float intensity,at,af;

	cf = diffuse * (gl_FrontMaterial.diffuse).rgb + 
									(gl_FrontMaterial.ambient).rgb;
	
	af = (gl_FrontMaterial.diffuse).a;

	texel = texture2D(tex,gl_TexCoord[0].st);
	ct = texel.rgb;
	at = texel.a;

	vec4 color = vec4(ct * cf, at * af);
	float c = color[0]*0.3 + color[1]*0.59 + color[2]*0.11;
	vec4 cv = vec4(c, c, c, color[3]);
	gl_FragColor = cv;
}
