uniform mat4 InverseEyeLookAtMatrix;
uniform mat4 LightLookAtMatrix;
uniform mat4 LightProjMatrix;

varying vec3 Normal;
varying vec4 Diffuse;
varying vec3 LightDirection;
//varying vec3 HalfVector;

varying vec4 ShadowCoord;
const mat4 ProjTexMatrix = mat4(
		0.5, 0  , 0  , 0  ,
		0  , 0.5, 0  , 0  ,
		0  , 0  , 0.5, 0  ,
		0.5, 0.5, 0.5, 1  );

varying vec4 LocalPosition;
varying vec4 Position;

void main()
{
	vec3 normal;
	//vec4 ecPos;
	vec3 lightDirection;
	vec4 diffuse;
	
	Normal = normalize(gl_NormalMatrix * gl_Normal);
	
	//ecPos = gl_ModelViewMatrix * gl_Vertex;
	LightDirection = normalize(vec3(gl_LightSource[0].position/*-ecPos*/));
	
	//HalfVector = normalize(gl_LightSource[0].halfVector.xyz);
	
	Diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	
	//gl_FrontColor = max(dot(normal, lightDirection), 0.) * diffuse;
	
	
	// shadowmap coordinate
	
	vec4 view;
	
	view = LightLookAtMatrix * InverseEyeLookAtMatrix *
			gl_ModelViewMatrix * gl_Vertex;
	//view.z += 0.05;
	view = LightProjMatrix * view;
	ShadowCoord = ProjTexMatrix * view;
	
	LocalPosition = gl_Vertex;
	Position = ftransform();
	gl_Position = Position;
}
