uniform sampler2DShadow ShadowMap;

uniform bool ApplyPaperMap; // special case
uniform sampler2D PaperMap;

uniform bool ApplyFaceMap; // special case
uniform sampler2D FaceMap;

varying vec3 Normal;
varying vec4 Diffuse;
varying vec3 LightDirection;
//varying vec3 HalfVector;

varying vec4 ShadowCoord;

varying vec4 LocalPosition;
varying vec4 Position;

vec4 queryPaper(sampler2D paperMap, vec4 pos);
vec4 queryFace(sampler2D faceMap, vec4 pos);

void main()
{
	vec3 normal;
	float nDotL;
	
	normal = normalize(Normal);
	
	nDotL = max(dot(normal, normalize(LightDirection)), 0.);
	
	gl_FragColor = Diffuse * mix(0.5, nDotL*1.960784314, 0.02);
	if(nDotL > 0.51)
	{
		vec4 shadowCoord = ShadowCoord / ShadowCoord.w;
		shadowCoord.z -= 0.001;
		float shadow = shadow2D(ShadowMap, shadowCoord.xyz).x;
		if(bool(shadow))
			gl_FragColor = mix(gl_FragColor, Diffuse * nDotL, shadow);
		//gl_FragColor = vec4(0., 0., 1., 1.);
	}
	
	gl_FragColor.a = (Position.z*20.)/Position.w-17.;
	
	if(ApplyPaperMap)
	{
		vec4 paper = queryPaper(PaperMap, LocalPosition);
		gl_FragColor *= paper;
	}
	
	if(ApplyFaceMap)
	{
		vec4 face = queryFace(FaceMap, LocalPosition);
		gl_FragColor *= face;
	}
	
}
