varying vec4 Position;
uniform sampler2D BlurMap;
uniform vec2 VideoDim;

const mat4 ProjTexMatrix = mat4(
		0.5, 0  , 0  , 0  ,
		0  , 0.5, 0  , 0  ,
		0  , 0  , 0.5, 0  ,
		0.5, 0.5, 0.5, 1  );

void main()
{
	vec4 p = Position / Position.w;
	//vec4 p = Position;
	
	float pixelW = 1./VideoDim.x;
	float pixelH = 1./VideoDim.y;

	vec4 a = ProjTexMatrix * vec4(p.x-pixelW, p.y-pixelH, p.z, p.w);
	vec4 b = ProjTexMatrix * vec4(p.x       , p.y-pixelH, p.z, p.w);
	vec4 c = ProjTexMatrix * vec4(p.x+pixelW, p.y-pixelH, p.z, p.w);
	
	vec4 d = ProjTexMatrix * vec4(p.x-pixelW, p.y       , p.z, p.w);
	vec4 e = ProjTexMatrix * vec4(p.x       , p.y       , p.z, p.w);
	vec4 f = ProjTexMatrix * vec4(p.x+pixelW, p.y       , p.z, p.w);
	
	vec4 g = ProjTexMatrix * vec4(p.x-pixelW, p.y+pixelH, p.z, p.w);
	vec4 h = ProjTexMatrix * vec4(p.x       , p.y+pixelH, p.z, p.w);
	vec4 i = ProjTexMatrix * vec4(p.x+pixelW, p.y+pixelH, p.z, p.w);
	
	vec4 value;
	
	value  = texture2D(BlurMap, a.xy);
	value += texture2D(BlurMap, b.xy) * 2.;
	value += texture2D(BlurMap, c.xy);
	
	value += texture2D(BlurMap, d.xy) * 2.;
	value -= texture2D(BlurMap, e.xy) *12.;
	value += texture2D(BlurMap, f.xy) * 2.;
	
	value += texture2D(BlurMap, g.xy);
	value += texture2D(BlurMap, h.xy) * 2.;
	value += texture2D(BlurMap, i.xy);
	
	value = abs(value);
	
	if((value.r > 0.05) || (value.g > 0.05) || (value.b > 0.05) ||
			(value.a > 0.05))
	{
		gl_FragColor = vec4(0.,0.,0.,1.);
	}
	else
	{
		vec4 color = vec4(texture2D(BlurMap, e.xy).rgb, 1.);
		color.r = floor(color.r * 5.) / 5.;
		color.g = floor(color.g * 5.) / 5.;
		color.b = floor(color.b * 5.) / 5.;
		gl_FragColor = color;
	}
	
	//gl_FragColor = texture2D(BlurMap, e.xy)*20.-19.;
	//gl_FragColor = vec4(pow(texture2D(BlurMap, e.xy), 32.));
	//gl_FragColor = texture2D(BlurMap, e.xy);
	
}
