varying vec3 Normal;
varying vec4 Diffuse;
varying vec3 LightDirection;

void main()
{
	vec3 normal;
	vec4 diffuse;
	vec3 lightDirection;
	
	normal = normalize(gl_NormalMatrix * gl_Normal);
	Normal = normal;
	
	lightDirection = normalize(vec3(gl_LightSource[0].position));
	LightDirection = lightDirection;
	
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	Diffuse = diffuse;
	
	//gl_FrontColor = max(dot(normal, lightDirection), 0.) * diffuse;
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
}
