varying vec3 normal;
varying vec3 view;
varying vec3 lightdirection;

void main(void)
{
 vec3 V = normalize(-view);
 vec3 R = normalize(-reflect(lightdirection,normal));

 vec4 Ambient        = gl_LightSource[0].ambient;
 vec4 Diffuse        = gl_LightSource[0].diffuse * max(dot(normal, lightdirection), 0.0);

 vec4 Specular       = gl_LightSource[0].specular * pow(max(dot(R, V), 0.0), gl_FrontMaterial.shininess);

 gl_FragColor = gl_FrontLightModelProduct.sceneColor + Ambient + Diffuse + Specular;
}