// Specular GLSL Fragment Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D BaseMap1;
uniform sampler2D BaseMap2;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec3 v2f_ViewVec;
varying vec2 v2f_Texcoord;

void main()
{
	vec4 LightColor = vec4(1.0, 0.0, 0.0, 1.0);

	// Sampeling color and bump map
	vec4 Color = texture2D(BaseMap1, v2f_Texcoord*60.0) * texture2D(BaseMap2, v2f_Texcoord*42.2);
	vec3 Normal = normalize(v2f_Normal);

	// Normalize the interpolated Light and View Vector
	vec3 LightVec = normalize(v2f_LightVec);
	vec3 ViewVec = normalize(v2f_ViewVec);

	// Calculating Diffuse Term
	float DiffuseTerm = max(dot(LightVec, Normal), 0.0);

	// Calculating Specular Term 
	vec3 Reflect = normalize(2.0 * DiffuseTerm * Normal - LightVec);
	float Specular = pow(clamp(dot(Reflect, ViewVec), 0.0, 1.0), 4.0);

	// Calculating the final Color
	 //Color * (1.0 + DiffuseTerm) + Specular;
	gl_FragColor = Color * (0.5 + DiffuseTerm) + vec4(Specular)*0.7;
	gl_FragColor.w = 0.5 + Specular*0.5;
}