// Diffuse GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D BaseMap;
uniform sampler2D PathMap;
uniform sampler2D PathAlphaMap;
uniform sampler2D LogicMap;

uniform sampler2D ShadowMap;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec2 v2f_Texcoord;

void main()
{
	// Define the Colors
	float PathAlpha = texture2D(PathAlphaMap, vec2(v2f_Texcoord.y,1.0-v2f_Texcoord.x)).x;
	vec4 Color = texture2D(BaseMap, v2f_Texcoord*30.0) * gl_LightSource[0].diffuse * (1.0-PathAlpha);
	Color += texture2D(PathMap, v2f_Texcoord*30.0) * gl_LightSource[0].diffuse * PathAlpha;

	// Normalize the interpolated Normal and Light Vector
	vec3 Normal = normalize(v2f_Normal);
	vec3 LightVec = normalize(v2f_LightVec);
	
	float DiffuseTerm = max(dot(LightVec, Normal), 0.0);

	gl_FragColor = Color * (0.3 + DiffuseTerm*0.7);// *
		//texture2D(LogicMap, vec2(v2f_Texcoord.y,1.0-v2f_Texcoord.x));
}