// Bump Mapping GLSL Fragment Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D BaseMap;
uniform sampler2D BumpMap;
uniform sampler2D ShadowMap;

varying vec3 v2f_LightVec;
varying vec3 v2f_ViewVec;
varying vec2 v2f_Texcoord;

void main()
{
	const vec4 LightColor = vec4(1.0, 0.0, 0.0, 1.0);

	// Sampeling color and bump map
	vec4 Color = texture2D(BaseMap, v2f_Texcoord) * gl_LightSource[0].diffuse;
	vec3 Normal = normalize((vec3(texture2D(BumpMap, v2f_Texcoord))) - 0.5);

	// Normalize the interpolated Light and View Vector
	vec3 LightVec = normalize(v2f_LightVec);
	vec3 ViewVec = normalize(v2f_ViewVec);

	// Calculating Diffuse Term
	float DiffuseTerm = max(dot(LightVec, Normal), 0.0);
 
	// Calculating Self-Shadowing Term
	float Shadow = min(DiffuseTerm * 4.0, 1.0);

	// Calculating Specular Term 
	vec3 Reflect = normalize(2.0 * DiffuseTerm * Normal - LightVec);
	vec4 Specular = vec4(min(pow(clamp(dot(Reflect, ViewVec), 0.0, 1.0), 16.0), Color.w));

	// Calculating the final Color
	gl_FragColor = Color*0.15 + Shadow*(Color*DiffuseTerm + 0.2*Specular);
}