// ShadowMap Linear GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D StaticShadowMap;
uniform sampler2D DynamicShadowMap;

varying vec2 v2f_Texcoord;

void main()
{
	vec4 static_shadow_value = texture2D(StaticShadowMap, v2f_Texcoord);
	vec4 dynamic_shadow_value = texture2D(DynamicShadowMap, v2f_Texcoord);

	gl_FragColor = max(static_shadow_value, dynamic_shadow_value);
}