// Bump Mapping GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

#define ShadowProjTexAdjMatrix gl_TextureMatrix[7]
#define ShadowProjMatrix gl_TextureMatrix[6]
#define ObjectMatrix gl_TextureMatrix[5]
uniform float zFar, zNear;

attribute vec3 a2v_Normal;
attribute vec3 a2v_Tangent;
attribute vec3 a2v_Binormal;
attribute vec2 a2v_Texcoord;

varying vec3 v2f_LightVec;
varying vec3 v2f_ViewVec;
varying vec2 v2f_Texcoord;

varying vec2 v2f_ShadowTexcoord;
varying float v2f_Depth;

void main()
{
	// Vertex transformation
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

	// Calculating TBN
	vec3 Tangent = gl_NormalMatrix * a2v_Tangent;
	vec3 Binormal = gl_NormalMatrix * a2v_Binormal;
	vec3 Normal = gl_NormalMatrix * a2v_Normal;
	
	// Calculating Light vector in ModelView Space
	vec3 Vertex_Model = vec3(gl_ModelViewMatrix * gl_Vertex);	
	vec3 LightVec = vec3(gl_LightSource[0].position) - Vertex_Model;

	//v2f_LightVec = vec3(1.0, 0.0, 0.0);
	//v2f_ViewVec = vec3(1.0, 0.0, 0.0);

	v2f_LightVec.x = dot(LightVec, Tangent);
	v2f_LightVec.y = dot(LightVec, Binormal);
	v2f_LightVec.z = dot(LightVec, Normal);
	
	// Calculating View vector in ModelView Space
	v2f_ViewVec.x = dot(-Vertex_Model, Tangent);
	v2f_ViewVec.y = dot(-Vertex_Model, Binormal);
	v2f_ViewVec.z = dot(-Vertex_Model, Normal);
	
	// Passing texture coordinates to fragment shader
	v2f_Texcoord = a2v_Texcoord;

	// Shadow Calculation
	vec4 VertexObjectSpace = ObjectMatrix * gl_Vertex;
	vec4 Position = ShadowProjMatrix * VertexObjectSpace;
	v2f_Depth = (1.0-Position.z)*0.5 + 0.004;

	v2f_ShadowTexcoord = vec2(ShadowProjTexAdjMatrix * VertexObjectSpace);
}