#version 430 core
/*
* Copyright 2018 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

// reference for cook torrance shader: https://github.com/pboechat/cook_torrance/tree/master/application/shaders

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

out vec3 view_direction;
out vec3 light_direction;
out float light_distance;

uniform vec3 camera_position;
uniform vec3 light_position;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;

void main() {
	//vert.normal_world = normalMatrix * normal;
	//vert.uv = uv;
	//vec4 position_world_ = modelMatrix * vec4(position, 1);
	//vert.position_world = position_world_.xyz;

	vert.normal_world = (modelMatrix * vec4(normal, 0)).xyz;

	vec4 position_world_ = modelMatrix * vec4(position, 1.0f);

	view_direction = normalize(camera_position - position_world_.xyz);
	light_direction = light_position - position_world_.xyz;
	light_distance = length(light_direction);
	light_direction /= light_distance;
	light_distance *= light_distance;

	vert.position_world = position_world_.xyz;
	vert.uv = uv;

	gl_Position = viewProjMatrix * position_world_;
}