#version 430 core
layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uvs;


out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;


uniform mat4 projection;
uniform mat4 transformation;
uniform mat3 normalMatrix;


void main()
{	
	vert.normal_world = normalMatrix * normal;
	vec4 position_world_ = transformation * vec4(position, 1.0);
	vert.position_world = position_world_.xyz;
	vert.uv = uvs;
    gl_Position = projection * transformation * vec4(position, 1.0);
}