
#version 330 core
out vec4 FragColor;
in vec3 pos;

uniform float time;
uniform vec2 res;

in VertexData {
  vec3 position_world;
  vec3 normal_world;
  vec2 uv;
} vert;



#define PI 3.14

float rand (in vec2 st) {
    return fract(sin(dot(st.xy,
                         vec2(12.9898,78.233)))
                 * 43758.5453123);
}

// Perlin Noise
// https://gist.github.com/patriciogonzalezvivo/670c22f3966e662d2f83
vec4 permute(vec4 x){return mod(((x*34.0)+1.0)*x, 289.0);}
vec2 fade(vec2 t) {return t*t*t*(t*(t*6.0-15.0)+10.0);}
float perlin(vec2 P){
  vec4 Pi = floor(P.xyxy) + vec4(0.0, 0.0, 1.0, 1.0);
  vec4 Pf = fract(P.xyxy) - vec4(0.0, 0.0, 1.0, 1.0);
  Pi = mod(Pi, 289.0); // To avoid truncation effects in permutation
  vec4 ix = Pi.xzxz;
  vec4 iy = Pi.yyww;
  vec4 fx = Pf.xzxz;
  vec4 fy = Pf.yyww;
  vec4 i = permute(permute(ix) + iy);
  vec4 gx = 2.0 * fract(i * 0.0243902439) - 1.0; // 1/41 = 0.024...
  vec4 gy = abs(gx) - 0.5;
  vec4 tx = floor(gx + 0.5);
  gx = gx - tx;
  vec2 g00 = vec2(gx.x,gy.x);
  vec2 g10 = vec2(gx.y,gy.y);
  vec2 g01 = vec2(gx.z,gy.z);
  vec2 g11 = vec2(gx.w,gy.w);
  vec4 norm = 1.79284291400159 - 0.85373472095314 * 
    vec4(dot(g00, g00), dot(g01, g01), dot(g10, g10), dot(g11, g11));
  g00 *= norm.x;
  g01 *= norm.y;
  g10 *= norm.z;
  g11 *= norm.w;
  float n00 = dot(g00, vec2(fx.x, fy.x));
  float n10 = dot(g10, vec2(fx.y, fy.y));
  float n01 = dot(g01, vec2(fx.z, fy.z));
  float n11 = dot(g11, vec2(fx.w, fy.w));
  vec2 fade_xy = fade(Pf.xy);
  vec2 n_x = mix(vec2(n00, n01), vec2(n10, n11), fade_xy.x);
  float n_xy = mix(n_x.x, n_x.y, fade_xy.y);
  return 2.3 * n_xy;
}


void main() {
    vec2 st = vert.uv;
    st *= 7.0;
    // st = (st-vec2(5.0))*(abs(sin(time*0.2))*5.);
    st.x += time*0.2;
    st.y += time*0.2;

    float noise = perlin(st);
    noise *= 5.0;
    //float normalizedFrag = gl_FragCoord.x/15.0;
    float x = sin(vert.uv.x*30+noise);
    
    vec3 color = 1.0/(vec3(x) * vec3(0.248,0.328,0.700));
    
    float threshold = 1.0;
    if(color.x > threshold || color.y > threshold || color.z > threshold){
        color = vec3(0.031,0.289,0.985);
    }else{
        color = vec3(0.123,0.227,0.665);
    } 
 
    FragColor = vec4(color, 1.0);
}