#version 430
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

out float ttl;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;

struct PStruct
{
	vec4 position;
	vec4 velocity;
};

layout (std430, binding=1) buffer Particles_in
{
	PStruct particles_in[];
};



void main() {
	vert.normal_world = normalMatrix * normal;
	vert.uv = uv;
	vec4 position_world_ = modelMatrix * vec4(position + particles_in[gl_InstanceID].position.xyz, 1);

	//vec4 position_world_ = modelMatrix * vec4(position + vec3(2,2,2), 1);


	vert.position_world = position_world_.xyz;
	gl_Position = viewProjMatrix * position_world_;

	ttl = particles_in[gl_InstanceID].position.a;
}