#version 430 core
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/


layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;
uniform float time;

void main() {
    
    
    float F = 30; //frequency
    float A = 3.5; //amplitude
    float T = 0.05; //time
    float X = 1.7;
    float Z = 1.0;
    
    float change_posY = sin((uv[0] + time * T * X) * F) / A + sin((uv[1] + time * T * Z) * F) / A ;
    vec3 change_pos = vec3(0, change_posY, 0);
    vec4 position_world = modelMatrix * vec4(position + change_pos, 1);
    
    float change_normX = sin((uv[0] + time * T * X) * F) / A  + cos((uv[1] + time * T * Z) * F) / A ;
    float change_normZ = cos((uv[0] + time * T * X) * F) / A  + sin((uv[1] + time * T * Z) * F) / A ;
    vec3 change_norm = vec3(change_normX, 0, change_normZ);
    vec3 normal_world = normalMatrix * (normal + change_norm);
    
    
    //vec3 p = position + ( (0.3 * sin(20 * uv[1] + time * 0.6) + 0.3 * sin(40 * uv[0] + time * 0.6)) * normal);
    //float grad_x =        (0.3 * cos(20 * uv[1] + time * 0.6) + 0.3 * sin(40 * uv[0] + time * 0.6));
    //float grad_z =        (0.3 * sin(20 * uv[1] + time * 0.6) + 0.3 * cos(40 * uv[0] + time * 0.6));
    
    //vec4 position_world = modelMatrix * vec4(p, 1);
    //vert.normal_world = normalMatrix * normalize(vec3(-grad_x, 1, -grad_z));
    
    
    
    
    //vec3 change = (2 * (sin(uv[0] + time) + sin(uv[1] + time)) / 10) * normal;
    //vec4 position_world = modelMatrix * vec4(position + change, 1);
    vert.position_world = position_world.xyz;

    //float changeN = (2 * (cos(uv[0] + time) + sin(uv[1] + time)) / 10);
    //vert.normal_world = normalMatrix * vec3(normal + vec3(changeN, 0, changeN));
    vert.normal_world = normal_world;
    
   // vert.position_world = position_world_.xyz;
    
	vert.uv = uv;
	//vert.position_world = position_world.xyz;
	gl_Position = viewProjMatrix * position_world;
}