#version 430 core


layout(points) in;
layout(points, max_vertices = 30) out;

out vec3 Position1;
out vec3 Velocity1;
out float Age1;


in vec3 Position0[];
in vec3 Velocity0[];
in float Age0[];


uniform float deltaMil;
uniform float startPos;
uniform float endPos;

void main() 
{
    Velocity1 = Velocity0[0];  
    Age1 = 0.0f;
    
    if (Position0[0].y < endPos) {
        Position1 = Position0[0];
        Position1.y = startPos;
    } else {
        Position1 = Position0[0] + Velocity1 * deltaMil;
    }
    
    
    EmitVertex();
    EndPrimitive();
}