#version 430 core


layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

uniform mat4 projMatrix;
uniform vec3 cameraPos;


void main()
{
    
    vec3 pos = gl_in[0].gl_Position.xyz;
    vec3 toCamera = normalize(cameraPos-pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    vec3 right = cross(toCamera, up)/20;
    //vec3 right = cross(toCamera, up);
    
    pos -= (right*0.5);
    gl_Position = projMatrix*vec4(pos, 1.0);
    EmitVertex();
    
    pos.y += 0.05;
    //pos.y += 1.0;
    gl_Position = projMatrix*vec4(pos, 1.0);
    EmitVertex();
    
    pos.y -= 0.05;
    //pos.y -= 1.0;
    pos += right;
    gl_Position = projMatrix*vec4(pos, 1.0);
    EmitVertex();
    
    pos.y += 0.05;
    //pos.y += 1.0;
    gl_Position = projMatrix*vec4(pos, 1.0);
    EmitVertex();
    
    EndPrimitive();
}